/********************************************
; File: Dialog.h
;
;
; Copyright Apple Computer, Inc.1986-90
; All Rights Reserved
;
********************************************/

#ifndef __TYPES__
#include <TYPES.h>
#endif

#ifndef __QUICKDRAW__
#include <QUICKDRAW.h>
#endif

#ifndef __EVENT__
#include <EVENT.h>
#endif

#ifndef __CONTROL__
#include <CONTROL.h>
#endif

#ifndef __WINDOW__
#include <WINDOW.h>
#endif

#ifndef __LINEEDIT__
#include <LINEEDIT.h>
#endif

#ifndef __DIALOG__
#define __DIALOG__


/* Error Codes */
#define badItemType 0x150A
#define newItemFailed 0x150B
#define itemNotFound 0x150C
#define notModalDialog 0x150D

/* Command Codes */
#define getInitView 0x0001
#define getInitTotal 0x0002
#define getInitValue 0x0003
#define scrollLineUp 0x0004
#define scrollLineDown 0x0005
#define scrollPageUp 0x0006
#define scrollPageDown 0x0007
#define scrollThumb 0x0008

/* Item Type Codes */
#define buttonItem 0x000A
#define checkItem 0x000B
#define radioItem 0x000C
#define scrollBarItem 0x000D
#define userCtlItem 0x000E
#define statText 0x000F
#define longStatText 0x0010
#define editLine 0x0011
#define iconItem 0x0012
#define picItem 0x0013
#define userItem 0x0014
#define userCtlItem2 0x0015
#define longStatText2 0x0016
#define itemDisable 0x8000

/* Item Type Ranges */
#define minItemType 0x000A
#define maxItemType 0x0016

/* ItemID Codes */
#define ok 0x0001
#define cancel 0x0002

/* Part Codes */
#define inButton 0x0002
#define inCheckBox 0x0003
#define inRadioButton 0x0004
#define inUpArrow 0x0005
#define inDownArrow 0x0006
#define inPageUp 0x0007
#define inPageDown 0x0008
#define inStatText 0x0009
#define inGrow 0x000A
#define inEditLine 0x000B
#define inUserItem 0x000C
#define inLongStatText 0x000D
#define inIconItem 0x000E
#define inLongStatText2 0x000F
#define inThumb 0x0081

/* Stage Bit Vectors */
#define okDefault 0x0000
#define cancelDefault 0x0040
#define alertDrawn 0x0080

/* Other Constants */
#ifndef atItemListLength  /* AlertTemplate - Default number of Item Templates */
#define atItemListLength 0x0005
#endif
#ifndef dtItemListLength  /* DialogTemplate - Default number of Item Templates */
#define dtItemListLength 0x0008
#endif

typedef GrafPortPtr DialogPtr;
struct ItemTemplate {
   Word itemID; /*  */
   Rect itemRect; /*  */
   Word itemType; /*  */
   Pointer itemDescr; /*  */
   Word itemValue; /*  */
   Word itemFlag; /*  */
   Pointer itemColor; /* pointer to appropriate type of color table */
} ;
typedef struct ItemTemplate ItemTemplate, *ItemTempPtr, **ItemTempHndl;

struct AlertTemplate {
   Rect atBoundsRect;
   Word atAlertID;
   Byte atStage1;
   Byte atStage2;
   Byte atStage3;
   Byte atStage4;
   ItemTempPtr atItemList[atItemListLength]; /* Null terminated array */
} ;
typedef struct AlertTemplate AlertTemplate, *AlertTempPtr, **AlertTempHndl;

struct DialogTemplate {
   Rect dtBoundsRect;
   Boolean dtVisible;
   Longint dtRefCon;
   ItemTempPtr dtItemList[dtItemListLength]; /* Null terminated array */
} ;
typedef struct DialogTemplate DialogTemplate, *DlgTempPtr, **DlgTempHndl;

struct UserCtlItemPB {
   LongProcPtr defProcParm;
   Pointer titleParm;
   Word param2;
   Word param1;
} ;
typedef struct UserCtlItemPB UserCtlItemPB, *UserCtlItemPBPtr, **UserCtlItemPBHndl;

extern pascal Word Alert() inline(0x1715,dispatcher);
extern pascal Word CautionAlert() inline(0x1A15,dispatcher);
extern pascal void CloseDialog() inline(0x0C15,dispatcher);
extern pascal Boolean DefaultFilter() inline(0x3615,dispatcher);
extern pascal void DialogBootInit() inline(0x0115,dispatcher);
extern pascal void DialogReset() inline(0x0515,dispatcher);
extern pascal Boolean DialogSelect() inline(0x1115,dispatcher);
extern pascal void DialogShutDown() inline(0x0315,dispatcher);
extern pascal void DialogStartUp() inline(0x0215,dispatcher);
extern pascal Boolean DialogStatus() inline(0x0615,dispatcher);
extern pascal Word DialogVersion() inline(0x0415,dispatcher);
extern pascal void DisableDItem() inline(0x3915,dispatcher);
extern pascal void DlgCopy() inline(0x1315,dispatcher);
extern pascal void DlgCut() inline(0x1215,dispatcher);
extern pascal void DlgDelete() inline(0x1515,dispatcher);
extern pascal void DlgPaste() inline(0x1415,dispatcher);
extern pascal void DrawDialog() inline(0x1615,dispatcher);
extern pascal void EnableDItem() inline(0x3A15,dispatcher);
extern pascal void ErrorSound() inline(0x0915,dispatcher);
extern pascal Word FindDItem() inline(0x2415,dispatcher);
extern pascal Word GetAlertStage() inline(0x3415,dispatcher);
extern pascal CtlRecHndl GetControlDItem() inline(0x1E15,dispatcher);
extern pascal Word GetDefButton() inline(0x3715,dispatcher);
extern pascal void GetDItemBox() inline(0x2815,dispatcher);
extern pascal Word GetDItemType() inline(0x2615,dispatcher);
extern pascal Word GetDItemValue() inline(0x2E15,dispatcher);
extern pascal Word GetFirstDItem() inline(0x2A15,dispatcher);
extern pascal void GetIText() inline(0x1F15,dispatcher);
extern pascal void GetNewDItem() inline(0x3315,dispatcher);
extern pascal DialogPtr GetNewModalDialog() inline(0x3215,dispatcher);
extern pascal Word GetNextDItem() inline(0x2B15,dispatcher);
extern pascal void HideDItem() inline(0x2215,dispatcher);
extern pascal Boolean IsDialogEvent() inline(0x1015,dispatcher);
extern pascal Word ModalDialog() inline(0x0F15,dispatcher);
extern pascal LongWord ModalDialog2() inline(0x2C15,dispatcher);
extern pascal void NewDItem() inline(0x0D15,dispatcher);
extern pascal DialogPtr NewModalDialog() inline(0x0A15,dispatcher);
extern pascal DialogPtr NewModelessDialog() inline(0x0B15,dispatcher);
extern pascal Word NoteAlert() inline(0x1915,dispatcher);
extern pascal void ParamText() inline(0x1B15,dispatcher);
extern pascal void RemoveDItem() inline(0x0E15,dispatcher);
extern pascal void ResetAlertStage() inline(0x3515,dispatcher);
extern pascal void SelectIText() inline(0x2115,dispatcher);
extern pascal void SelIText() inline(0x2115,dispatcher);
extern pascal void SetDAFont() inline(0x1C15,dispatcher);
extern pascal void SetDefButton() inline(0x3815,dispatcher);
extern pascal void SetDItemBox() inline(0x2915,dispatcher);
extern pascal void SetDItemType() inline(0x2715,dispatcher);
extern pascal void SetDItemValue() inline(0x2F15,dispatcher);
extern pascal void SetIText() inline(0x2015,dispatcher);
extern pascal void ShowDItem() inline(0x2315,dispatcher);
extern pascal Word StopAlert() inline(0x1815,dispatcher);
extern pascal void UpdateDialog() inline(0x2515,dispatcher);

#endif
